IF OBJECT_ID('[P_EXP_CTB_MOV_ATUALIZA_CNT_CTB]') IS NOT NULL
	BEGIN
		DROP PROCEDURE [P_EXP_CTB_MOV_ATUALIZA_CNT_CTB]
	END
GO
CREATE PROCEDURE [dbo].[P_EXP_CTB_MOV_ATUALIZA_CNT_CTB]		
WITH ENCRYPTION AS 

BEGIN TRY
BEGIN
	
	------------------------------------------------------------------------------------------------------------------------------
	--ATUALIZANDO CONTAS CONTABEIS DAS FILIAIS E LANCAMENTO NO CENTRO DE CUSTO DA TABELA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------	
	UPDATE MOV SET 
		CD_CNT_RED_CREDITO	= (CASE WHEN TP_TRANSA = 'C' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_CREDITO,0) = 0) THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_CREDITO		= (CASE WHEN TP_TRANSA = 'C' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_CREDITO,'') = '')   THEN ISNULL(CNT_CTB.CD_CTB_CNT,0)		ELSE 0 END),
		CD_CNT_RED_DEBITO	= (CASE WHEN TP_TRANSA = 'D' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_DEBITO,0) = 0)  THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_DEBITO		= (CASE WHEN TP_TRANSA = 'D' OR (TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_DEBITO,'') = '')    THEN ISNULL(CNT_CTB.CD_CTB_CNT,0)		ELSE 0 END),		
		
		DS_CENTRO_CUSTO		= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.DS_CENTRO_CTB	ELSE '' END),
		CNT_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.CNT_CENTRO_CTB ELSE 0 END),
		VLR_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN MOV.VLR_LANC					ELSE 0 END),
		RATEIO_CENTRO_CUSTO = (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN 1								ELSE 0 END)
		
	FROM ##CTB_EXP_MOV MOV 
		INNER JOIN PRC_FILIAL_CNT_CTB CNT_CTB ON
			MOV.CD_EMP		= CNT_CTB.CD_EMP AND
			MOV.CD_FILIAL	= CNT_CTB.CD_FILIAL AND 
			MOV.COD_CONTA   = CNT_CTB.TP_CNT_CTB
		LEFT JOIN CTB_CENTRO_CUSTO ON
			CNT_CTB.CD_EMP			= CTB_CENTRO_CUSTO.CD_EMP AND
			CNT_CTB.CD_CENTRO_CTB	= CTB_CENTRO_CUSTO.CD_CENTRO_CTB
			
	WHERE 
		MOV.ORIG_CONTA = 'FILIAIS'


	------------------------------------------------------------------------------------------------------------------------------
	--ATUALIZANDO CONTAS CONTABEIS DA MATRIZ E LANCAMENTO NO CENTRO DE CUSTO DA TABELA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------	
	UPDATE MOV SET 
		CD_CNT_RED_CREDITO	= (CASE WHEN MOV.TP_TRANSA = 'C' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_CREDITO,0) = 0) THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_CREDITO		= (CASE WHEN MOV.TP_TRANSA = 'C' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_CREDITO,'') = '')   THEN ISNULL(CNT_CTB.CD_CTB_CNT,0)		ELSE 0 END),
		CD_CNT_RED_DEBITO	= (CASE WHEN MOV.TP_TRANSA = 'D' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_DEBITO,0) = 0)  THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_DEBITO		= (CASE WHEN MOV.TP_TRANSA = 'D' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_DEBITO,'') = '')    THEN ISNULL(CNT_CTB.CD_CTB_CNT,0)		ELSE 0 END),		
		
		DS_CENTRO_CUSTO		= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.DS_CENTRO_CTB	ELSE '' END),
		CNT_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.CNT_CENTRO_CTB ELSE 0 END),
		VLR_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN MOV.VLR_LANC					ELSE 0 END),
		RATEIO_CENTRO_CUSTO = (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN 1								ELSE 0 END)
		
	FROM ##CTB_EXP_MOV MOV 
		INNER JOIN PRC_FILIAL_CNT_CTB CNT_CTB ON
			MOV.CD_EMP		= CNT_CTB.CD_EMP AND		
			MOV.COD_CONTA   = CNT_CTB.TP_CNT_CTB
		LEFT JOIN CTB_CENTRO_CUSTO ON
			CNT_CTB.CD_EMP			= CTB_CENTRO_CUSTO.CD_EMP AND
			CNT_CTB.CD_CENTRO_CTB	= CTB_CENTRO_CUSTO.CD_CENTRO_CTB
			
	WHERE 
		MOV.ORIG_CONTA = 'MATRIZ'
		AND CNT_CTB.CD_FILIAL IN (SELECT F.CD_FILIAL FROM PRC_FILIAL F WHERE F.FILIAL_MTZ = 1)


	------------------------------------------------------------------------------------------------------------------------------
	--ATUALIZANDO CONTAS CONTABEIS DA MATRIZ E LANCAMENTO NO CENTRO DE CUSTO DA TABELA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------	
	UPDATE MOV SET 
		CD_CNT_RED_CREDITO	= (CASE WHEN MOV.TP_TRANSA = 'C' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_CREDITO,0) = 0) THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_CREDITO		= (CASE WHEN MOV.TP_TRANSA = 'C' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_CREDITO,'') = '')   THEN ISNULL(CNT_CTB.CD_CTB_CNT,0)		ELSE 0 END),
		CD_CNT_RED_DEBITO	= (CASE WHEN MOV.TP_TRANSA = 'D' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_RED_DEBITO,0) = 0)  THEN ISNULL(CNT_CTB.CD_CTB_CNT_RED,0)	ELSE 0 END),
		CD_CNT_DEBITO		= (CASE WHEN MOV.TP_TRANSA = 'D' OR (MOV.TP_TRANSA = 'A' AND ISNULL(MOV.CD_CNT_DEBITO,'') = '')    THEN ISNULL(CNT_CTB.CD_CTB_CNT,0)		ELSE 0 END),		
		
		DS_CENTRO_CUSTO		= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.DS_CENTRO_CTB	ELSE '' END),
		CNT_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN CTB_CENTRO_CUSTO.CNT_CENTRO_CTB ELSE 0 END),
		VLR_CENTRO_CUSTO	= (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN MOV.VLR_LANC					ELSE 0 END),
		RATEIO_CENTRO_CUSTO = (CASE WHEN CNT_CTB.CD_CENTRO_CTB > 0 AND MOV.RATEIO_CENTRO_CUSTO = 0 THEN 1								ELSE 0 END)
		
	FROM ##CTB_EXP_MOV MOV 
		INNER JOIN GLB_MOV_OP_CNT_CTB CNT_CTB ON				
			DBO.LIMPAR_NUMEROS(MOV.COD_CONTA)   = CNT_CTB.TP_CNT_CTB
		LEFT JOIN CTB_CENTRO_CUSTO ON
			CTB_CENTRO_CUSTO.CD_EMP			=	MOV.CD_EMP	AND			
			CTB_CENTRO_CUSTO.CD_CENTRO_CTB  =	ISNULL((SELECT (CASE WHEN ISNUMERIC(PR.VALOR) = 1 THEN PR.VALOR ELSE 0 END) 
												   	    FROM PRC_FILIAL_CONFIG PR 
														WHERE PR.CD_EMP = MOV.CD_EMP 
															  AND PR.CD_FILIAL = MOV.CD_FILIAL),0)
	WHERE 
		MOV.ORIG_CONTA LIKE 'NAT MOV%'
		 
END

END TRY
BEGIN CATCH
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH					
  
GO


